capture log close
clear all
macro drop _all
version 17.0
cd "/Users/mike_cunningham/Documents/Stata/OutputWeights25"
set more off
set maxiter 16000
set iterlog off

log using "Output/log/anLeonCost-DNSP25ml-24", replace text

/*--------------------------------------------------------------------------
Project: Quantonomics - DNSP output weights
Author:  Michael Cunningham 
File:    anLeonCost-DNSP25ml-24.do
Initial Date:    23-Sep-2025
Revised Date:	 
--------------------------------------------------------------------------*/

tempfile sampldat shout1 shout2 shout3 shout4 shout5 shout6 shout7 shout8 ///
	shout9 shout10 shout11 shout12 shout13 matB

********* Import data ***************

import excel using "Input/DNSP consolidated benchmarking data (2024).xlsx", ///
	sheet("Shazam DNSP Data") cellrange(A1:V249) clear firstrow case(l)
drop in 1
destring, replace	

********* Data management ********		
		
rename dnspyearidentifier			  dnspyear
rename totalrevenue                   rev
rename energy						  y1
rename ratchedmaximumdemand	          y2	
rename customernumbers                y3	
rename circuitlength                  y4	
rename customerminutesoffsupply       cmos	
rename priceopex                      p_x1	
rename overheadsubtransmissionlines   ohsubt 	
rename overheaddistributionlinesund   ohdist
rename undergroundsubtransmissionline ugsubt
rename undergrounddistributionlines   ugdist
rename transformersexcludingfirststa  x4
rename aucoverheadsubtransmission     auc_ohsubt
rename aucoverheaddistribution        auc_ohdist
rename aucundergroundsubtransmission  auc_ugsubt
rename aucundergrounddistribution     auc_ugdist
rename auctransformersexcludingfirst  auc_transf

gen double x1 = opex/p_x1
gen double x2 = ohsubt + ohdist
gen double x3 = ugsubt + ugdist

gen double p_x2 = (auc_ohsubt + auc_ohdist) / x2
gen double p_x3 = (auc_ugsubt + auc_ugdist) / x3
gen double p_x4 = auc_transf / x4

gen int dnsp = int(dnspyear/100)
gen int year = dnspyear - dnsp*100 + 2000
replace cmos = 1 if cmos < 1
gen int t = year - 2005

local varlist y1 y2 y3 y4 x1 x2 x3 x4 p_x1 p_x2 p_x3 p_x4 t
	
format %14.0g `varlist'
sort dnsp year
keep dnsp year `varlist'
order dnsp year `varlist'

label variable x1 "Real Opex"
label variable x2 "OH/Lines"
label variable x3 "UG/Cables"
label variable x4 "Transformers"
label variable p_x1 "Price Opex"
label variable p_x2 "Price OH/Lines"
label variable p_x3 "Price UG/Cables"
label variable p_x4 "Price Transformers"
label variable y1 "Energy"
label variable y2 "RMD"
label variable y3 "Customer No"
label variable y4 "Circuit Length"
label variable t  "Time"
describe	

********* Set sample period ****************

keep if year <= 2024
save `sampldat'

********* Estimate Leontief input demand models using ML ***********************

********************************************************************************
* Define programs for maximum likelihood estimation
********************************************************************************

capture program drop Opexfn
program Opexfn
	version 14.2
	args lnf b1 b2 b3 b4 bt sigma
	tempvar res
	quietly gen double `res' = x1 - (`b1'^2*y1+`b2'^2*y2+`b3'^2*y3+`b4'^2*y4)*(1+`bt'*t)
	quietly replace `lnf' = -0.5*ln(2*_pi)-ln(`sigma')-0.5*`res'^2/`sigma'^2
end

capture program drop OHfn
program OHfn
	version 14.2
	args lnf b1 b2 b3 b4 bt sigma
	tempvar res
	quietly gen double `res' = x2 - (`b1'^2*y1+`b2'^2*y2+`b3'^2*y3+`b4'^2*y4)*(1+`bt'*t)
	quietly replace `lnf' = -0.5*ln(2*_pi)-ln(`sigma')-0.5*`res'^2/`sigma'^2
end

capture program drop UGfn
program UGfn
	version 14.2
	args lnf b1 b2 b3 b4 bt sigma
	tempvar res
	quietly gen double `res' = x3 - (`b1'^2*y1+`b2'^2*y2+`b3'^2*y3+`b4'^2*y4)*(1+`bt'*t)
	quietly replace `lnf' = -0.5*ln(2*_pi)-ln(`sigma')-0.5*`res'^2/`sigma'^2
end

capture program drop Trfn
program Trfn
	version 14.2
	args lnf b1 b2 b3 b4 bt sigma
	tempvar res
	quietly gen double `res' = x4 - (`b1'^2*y1+`b2'^2*y2+`b3'^2*y3+`b4'^2*y4)*(1+`bt'*t)
	quietly replace `lnf' = -0.5*ln(2*_pi)-ln(`sigma')-0.5*`res'^2/`sigma'^2
end

********************************************************************************
* Run ML routines
********************************************************************************
/*
local violations=0
local violationsOpex=0
*/
forvalues mydnsp = 1(1)13 {

display "DNSP == `mydnsp'"

use `sampldat', clear
keep if dnsp==`mydnsp'

ml model lf Opexfn (b1:) (b2:) (b3:) (b4:) (bt:) (sigma:)
ml init b1:_cons=0.001
ml init b2:_cons=0.001
ml init b3:_cons=0.001
ml init b4:_cons=0.001
ml init bt:_cons=0.001
ml init sigma:_cons=100
capture noisily ml max, tol(1e-16) ltolerance(1e-16)
local 11=abs([b1]_cons)
local 12=abs([b2]_cons)
local 13=abs([b3]_cons)
local 14=abs([b4]_cons)
local 1t=[bt]_cons

ml model lf OHfn (b1:) (b2:) (b3:) (b4:) (bt:) (sigma:)
ml init b1:_cons=0.001
ml init b2:_cons=0.001
ml init b3:_cons=0.001
ml init b4:_cons=0.001
ml init bt:_cons=0.001
ml init sigma:_cons=100
capture noisily ml max, tol(1e-16) ltolerance(1e-16)
local 21=abs([b1]_cons)
local 22=abs([b2]_cons)
local 23=abs([b3]_cons)
local 24=abs([b4]_cons)
local 2t=[bt]_cons

ml model lf UGfn (b1:) (b2:) (b3:) (b4:) (bt:) (sigma:)
ml init b1:_cons=0.001
ml init b2:_cons=0.001
ml init b3:_cons=0.001
ml init b4:_cons=0.001
ml init bt:_cons=0.001
ml init sigma:_cons=100
capture noisily ml max, tol(1e-16) ltolerance(1e-16)
local 31=abs([b1]_cons)
local 32=abs([b2]_cons)
local 33=abs([b3]_cons)
local 34=abs([b4]_cons)
local 3t=[bt]_cons

ml model lf Trfn (b1:) (b2:) (b3:) (b4:) (bt:) (sigma:)
ml init b1:_cons=0.001
ml init b2:_cons=0.001
ml init b3:_cons=0.001
ml init b4:_cons=0.001
ml init bt:_cons=0.001
ml init sigma:_cons=100
capture noisily ml max, tol(1e-16) ltolerance(1e-16)
local 41=abs([b1]_cons)
local 42=abs([b2]_cons)
local 43=abs([b3]_cons)
local 44=abs([b4]_cons)
local 4t=[bt]_cons

gen x1E=(`11'^2*y1+`12'^2*y2+`13'^2*y3+`14'^2*y4)*(1+`1t'*t)
gen x2E=(`21'^2*y1+`22'^2*y2+`23'^2*y3+`24'^2*y4)*(1+`2t'*t)
gen x3E=(`31'^2*y1+`32'^2*y2+`33'^2*y3+`34'^2*y4)*(1+`3t'*t)
gen x4E=(`41'^2*y1+`42'^2*y2+`43'^2*y3+`44'^2*y4)*(1+`4t'*t)

gen CostE =p_x1*x1E + p_x2*x2E + p_x3*x3E + p_x4*x4E
gen CostE1=p_x1*`11'^2*y1*(1+`1t'*t)+p_x2*`21'^2*y1*(1+`2t'*t)+p_x3*`31'^2*y1*(1+`3t'*t)+p_x4*`41'^2*y1*(1+`4t'*t)
gen CostE2=p_x1*`12'^2*y2*(1+`1t'*t)+p_x2*`22'^2*y2*(1+`2t'*t)+p_x3*`32'^2*y2*(1+`3t'*t)+p_x4*`42'^2*y2*(1+`4t'*t)
gen CostE3=p_x1*`13'^2*y3*(1+`1t'*t)+p_x2*`23'^2*y3*(1+`2t'*t)+p_x3*`33'^2*y3*(1+`3t'*t)+p_x4*`43'^2*y3*(1+`4t'*t)
gen CostE4=p_x1*`14'^2*y4*(1+`1t'*t)+p_x2*`24'^2*y4*(1+`2t'*t)+p_x3*`34'^2*y4*(1+`3t'*t)+p_x4*`44'^2*y4*(1+`4t'*t)

gen SHOUT1=CostE1/CostE
gen SHOUT2=CostE2/CostE
gen SHOUT3=CostE3/CostE
gen SHOUT4=CostE4/CostE

matrix B`mydnsp' = (`11',`12',`13',`14',`1t' \ `21',`22',`23',`24',`2t' \ `31',`32',`33',`34',`3t' \ `41',`42',`43',`44',`4t')

save `shout`mydnsp''
}

use `shout1', clear
forvalues mydnsp = 2(1)13 {
append using `shout`mydnsp''
}

tab dnsp
tab year

qui sum CostE
gen S=CostE/r(sum)

gen SSHOUT1=S*SHOUT1
gen SSHOUT2=S*SHOUT2
gen SSHOUT3=S*SHOUT3
gen SSHOUT4=S*SHOUT4

qui sum SSHOUT1
local ShareEnergy=r(sum)

qui sum SSHOUT2
local ShareRMDemand=r(sum)

qui sum SSHOUT3
local ShareCustNum=r(sum)

qui sum SSHOUT4
local ShareCircLen=r(sum)

display "ShareEnergy  = `ShareEnergy'"
display "ShareRMD     = `ShareRMDemand'"
display "ShareCustNum = `ShareCustNum'"
display "ShareCircLen = `ShareCircLen'"

********************************************************************************

clear	
matrix B = B1\B2\B3\B4\B5\B6\B7\B8\B9\B10\B11\B12\B13
svmat B, names("a")
rename a5 b
gen obs = _n

save `matB'
use Input/catvars, clear
merge 1:1 obs using `matB'
drop _merge obs

forvalues i = 1/4 {
	replace a`i' = abs(a`i')
}
format a1 a2 a3 a4 b %9.3f

describe	
export excel using "Input/DNSP-InitialValuesML24.xlsx", firstrow(var) ///
	sheet("Sheet1", modify)
	
log close
exit

	